/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface IEventHandler<T> {
    public void invoke(Consumer<T> var1);

    public void invokeIf(Predicate<T> var1, Consumer<T> var2);

    public void addListener(T var1);

    public void removeListener(T var1);

    public List<T> listAll();

    public static <T> IEventHandler<T> newEventHandler() {
        return new EventHandler();
    }

    public static class EventHandler<T>
    implements IEventHandler<T> {
        private final List<T> list = new ArrayList<T>();

        private EventHandler() {
        }

        @Override
        public void invoke(Consumer<T> consumer) {
            this.list.forEach(consumer);
        }

        @Override
        public void invokeIf(Predicate<T> condition, Consumer<T> action) {
            this.list.stream().filter(condition).forEach(action);
        }

        @Override
        public void addListener(T t) {
            this.list.add(t);
        }

        @Override
        public void removeListener(T t) {
            this.list.remove(t);
        }

        @Override
        public List<T> listAll() {
            return this.list;
        }
    }
}

